<?php
session_start();
$brcode = $_SESSION['brcode'];
$user   = $_SESSION['user'];


include("../opendb.php");
require("../paypdf/fpdf.php");

$invno   = $_GET['invno'] ?? '';
// $foc, $invtype, $mprefix assumed from outside like your old file

// Basic validation: invoice exists?
$re = mysqli_query($db, "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode'");
if (mysqli_num_rows($re) <= 0) {
    echo "Invoice No does not exist";
    return;
}
$jcrow = mysqli_fetch_array($re);

// Branch state
$ker = mysqli_query($db, "SELECT brstate FROM branch WHERE brcode='$brcode'");
$kar = mysqli_fetch_array($ker);

// Decide which table to use (FOC vs normal)
if ($foc == 'foc') {
    $re = mysqli_query($db, "SELECT * FROM spareinvoicefoc WHERE invno='$invno' AND invtype='$invtype' AND brcode='$brcode'") or die('err:'.mysqli_error($db));
} else {
    $re = mysqli_query($db, "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode'") or die(mysqli_error($db));
}
$row = mysqli_fetch_array($re) or die("Fetch Error:".mysqli_error($db));

// E-invoice / QR code checks (same as your HTML version)
$chkflg = 0;
if ((($row['tin'] != 'NOT REGISTERED') && ($row['tin'] != 'NOT REGISTERD')) && ($row['entrydate'] >= '2021-01-01')) {
    $chkflg = 1;
}

$brres = mysqli_query($db, "SELECT * FROM branch WHERE brcode='$brcode'");
$brrow = mysqli_fetch_array($brres);

$cusres = mysqli_query($db, "SELECT * FROM customer WHERE acname='$row[customer]' AND brcode = '$brcode'");
$cusrow = mysqli_fetch_array($cusres);

$qrqry   = mysqli_query($db, "SELECT * FROM tbl_einvoice WHERE invno='$invno' AND brcode='$brcode'");
$qrrow   = mysqli_fetch_array($qrqry);
$signedqr = $qrrow['SignedQRCode'] ?? '';

if ($signedqr != '') {
    $chkflg = 0;
}

if (strtoupper($row['paytype']) == 'CASH' || strtoupper($row['paytype']) == 'SWIPPING MACHINE') {
    $chkflg = 0;
}

if ($chkflg == '1') {
    echo "QR code for E-invoice not generated. Please generate the same before printing invoice.";
    return;
}

// ---------- Helper: number format (like your putcoma) ----------
function putcoma_pdf($val)
{
    if ($val === '' || $val === null) return '';
    return number_format((float)$val, 2, '.', ',');
}

// ---------- QR code generation (phpqrcode -> PNG) ----------
$qrImagePath = '';
if ($signedqr != '') {
    $qrTempDir   = sys_get_temp_dir();
    $qrImagePath = $qrTempDir . DIRECTORY_SEPARATOR . 'qr_' . $invno . '.png';
    QRcode::png($signedqr, $qrImagePath, QR_ECLEVEL_L, 3, 1);
}

// ---------- Prepare some flags / values ----------
$entryDate  = $row['entrydate'];
$fromdt1    = implode('-', array_reverse(explode('-', $entryDate))); // DD-MM-YYYY style
$invTitleNo =  $invno;
$isIntrastate = ($row['vatorcst'] == 'INTRASTATE');
$isInterstate = ($row['vatorcst'] == 'INTERSTATE');

// ---------- Totals to accumulate ----------
$partstotal = 0;
$total_disc = 0;
$totcshdis  = 0;
$cgst_tot   = 0;
$sgst_tot   = 0;
$igst_tot   = 0;
$tcs_tot    = 0;
$hand_tot   = 0;
$jtot       = 0;

$eng      = '';
$ref_user = '';
$ref_note = '';
$valvolineflg = 0;

// Pre-scan items (needed for totals + flags)
$itemSql = "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode' ORDER BY cgstp,igstp,partcode";
$itemRes = mysqli_query($db, $itemSql);

$items = [];
$sl = 1;

while ($res1 = mysqli_fetch_assoc($itemRes)) {
    $qty   = (float)$res1['qty'];
    $price = (float)$res1['price'];

    $partstotal += $qty * $price;

    $discamt  = ($qty * $price) * $res1['disc'] / 100;
    $total_disc += $discamt;

    $afterdis = ($qty * $price) - $discamt;
    $cashdisamt = $afterdis * ($res1['cshdisc'] / 100);
    $totcshdis  += $cashdisamt;

    $eng = $res1['engineer'];
    $ref = $res1['ref'];

    if (strpos($ref, '|') > 0) {
        $ref_user = substr($ref, strpos($ref, '|') + 1, 100);
    } else {
        $ref_user = $ref;
    }
    $ref_note = substr($ref, 0, strpos($ref, '|'));

    $hand_tot += (float)$res1['hand'];

    // Check VALVOLINE
    $qry = "SELECT location,group1 FROM partmaster WHERE partcode='".$res1['partcode']."'";
    $rsqr = mysqli_query($db, $qry);
    $rsrw = mysqli_fetch_array($rsqr);
    if ($rsrw[1] == 'VALVOLINE') {
        $valvolineflg = 1;
    }

    if ($isIntrastate) {
        $cgst_tot += (float)$res1['cgstamt'];
        $sgst_tot += (float)$res1['sgstamt'];
        $igst_tot  = $igst_tot; // zero or existing
    } elseif ($isInterstate) {
        $igst_tot += (float)$res1['igstamt'];
    }

    $tcs_tot += (float)$res1['adltcsamt'];
    $jtot    += (float)$res1['tot'];

    // Build item array for later drawing
    $item = [
        'slno'     => $sl,
        'code'     => $res1['partcode'],
        'name'     => substr($res1['partname'], 0, 30),
        'qty'      => $qty,
        'rate'     => $price,
        'discper'  => (float)$res1['disc'],
        'cshdisc'  => (float)$res1['cshdisc'],
        'cessamt'  => (float)$res1['cessamt'], // used as MRP
        'cgstp'    => (float)$res1['cgstp'],
        'sgstp'    => (float)$res1['sgstp'],
        'igstp'    => (float)$res1['igstp'],
        'cgstamt'  => (float)$res1['cgstamt'],
        'sgstamt'  => (float)$res1['sgstamt'],
        'igstamt'  => (float)$res1['igstamt'],
        'tot'      => (float)$res1['tot'],
        'hand'     => (float)$res1['hand'],
        'hsn'      => '',
    ];

    // HSN/location
    if (strlen($rsrw[0]) > 5) {
        $item['hsn'] = $rsrw[0];
    } else {
        $item['hsn'] = '0';
    }

    $items[] = $item;
    $sl++;
}

// ---------- PDF Class ----------
class SpareInvoicePDF extends FPDF
{
    public $invTitleNo;
    public $invDate;
    public $row;
    public $brrow;
    public $cusrow;
    public $brcode;
    public $signedqr;
    public $irnno;
    public $qrImagePath;
    public $isIntrastate;
    public $isInterstate;
    public $valvolineflg;
    public $firstPageDone = false;

    function Header()
    {
        // Top logo + branch details + QR + Force logo
        $this->SetFont('Arial','',9);

        $this->Image('../images/psnlogo.jpg', 10, 8, 25, 15); // left logo

        // Branch block
        $this->SetXY(40, 8);
        $this->SetFont('Arial','B',11);
        $this->Cell(120, 5, 'GSTIN: '.$this->brrow['tin'], 0, 1, 'C');
        $this->SetFont('Arial','B',12);
        $this->Cell(120, 6, 'PSN AUTOMOTIVE MARKETING PVT LTD', 0, 1, 'C');
        $this->SetFont('Arial','',8);
        $addrLine = $this->brrow['braddr'];
        $this->Cell(120, 4, $addrLine, 0, 1, 'C');
        $this->Cell(120, 4, $this->brrow['brcity'].', '.$this->brrow['region'], 0, 1, 'C');
        $this->Cell(120, 4, 'Phone : '.$this->brrow['brphone'], 0, 1, 'C');
        $this->Cell(120, 4, 'CIN :'.$this->brrow['cstno'].'  PAN :'.$this->brrow['bilslno'], 0, 1, 'C');
        $this->Cell(120, 4, 'Email: '.$this->brrow['email'], 0, 1, 'C');

        // QR code on right
        if ($this->signedqr != '' && $this->qrImagePath && file_exists($this->qrImagePath)) {
            $this->Image($this->qrImagePath, 165, 8, 30, 30);
        }

        // Force logo (if not *ACC)
        if (substr($this->brcode, 3, 3) != 'ACC') {
            $this->Image('../images/force.png', 165, 30, 20, 20);
        }

        $this->Ln(3);

        // IRN row (if exists)
        if ($this->signedqr != '' && trim($this->irnno) != '') {
            $this->SetFont('Arial','',8);
            $this->Cell(0, 5, 'IRN : '.trim($this->irnno), 0, 1, 'L');
        }

        // Invoice header row
        $this->SetFont('Arial','',9);
        $this->Cell(60, 7, 'INVNO: '.$this->invTitleNo, 1, 0, 'L');

        $this->SetFont('Arial','B',10);
        $this->Cell(70, 7, 'FORM GST INV - 1', 1, 0, 'C');

        $this->SetFont('Arial','',9);
        $this->Cell(60, 7, 'INVDT: '.$this->invDate, 1, 1, 'R');

        // Cash Invoice / Tax Invoice below the title cell
        $this->SetXY(70, $this->GetY() - 7); // top of middle cell
        $this->SetFont('Arial','',8);
        $ptypeText = ($this->row['paytype'] == 'Cash') ? 'Cash Invoice' : 'Tax Invoice';
        $this->Cell(70, 7, $ptypeText, 0, 1, 'C');

        $this->Ln(2);
    }

    function Footer()
    {
        // Bank details + Page number
        $this->SetY(-30);
        $this->SetFont('Arial','',8);

        if ($this->brcode == 'BLRACC' || $this->brcode == 'HUBACC' || $this->brcode == 'HYDACC') {
            $bank = "Bank Details: PSN Automotive Marketing Pvt. Ltd\n".
                    "BRANCH   : Bank of Baroda, StJohns Medical College, Bangalore branch\n".
                    "A/c No.  : 05210200001133\n".
                    "IFSC Code: BARB0STJOHN";
        } else {
            $bank = "Bank Details: PSN Automotive Marketing Pvt. Ltd\n".
                    "BRANCH   : Bank of Baroda, StJohns Medical College, Bangalore branch\n".
                    "A/c No.  : 05210200001133\n".
                    "IFSC Code: BARB0STJOHN";
        }
        $this->MultiCell(0, 4, $bank, 0, 'L');

        $this->Ln(1);
        $this->Cell(0, 5, 'Page '.$this->PageNo().'/{nb}', 0, 0, 'R');
    }

    function ReceiverConsigneeBlock()
    {
        // Only printed once (first page)
        $this->SetFont('Arial','',8);

        $this->Cell(95, 5, 'Details of Receiver (Billed to)', 1, 0, 'L');
        $this->Cell(95, 5, 'Details of Consignee (Shipped to)', 1, 1, 'L');

        // Left: Receiver
        $x1 = $this->GetX();
        $y1 = $this->GetY();

        $this->SetFont('Arial','',8);
        $this->SetXY(10, $y1);
        $this->Cell(25, 5, 'Name', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->row['customer'], 0, 1, 'L');

        $addrBill = $this->cusrow['addr1'].', '.$this->cusrow['dist1'].', '.$this->cusrow['pin1'].', ('.$this->cusrow['corp'].') Phone:'.$this->cusrow['phone1'];
        $this->Cell(25, 5, 'Address', 0, 0, 'L');
        $this->MultiCell(70, 5, ': '.$addrBill, 0, 'L');

        $this->Cell(25, 5, 'State', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->cusrow['state1'], 0, 1, 'L');

        $this->Cell(25, 5, 'GSTIN', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->cusrow['gst'], 0, 1, 'L');

        $this->Cell(25, 5, 'PAN', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->cusrow['cst'], 0, 1, 'L');

        $hLeft = $this->GetY() - $y1;

        // Right: Consignee
        $this->SetXY(105, $y1);
        $this->Cell(25, 5, 'Name', 0, 0, 'L');
        $shipName = ($this->row['shipto'] != '') ? $this->row['shipto'] : $this->row['customer'];
        $this->Cell(70, 5, ': '.$shipName, 0, 1, 'L');

        if ($this->row['shipaddr'] != '') {
            $addrShip = $this->row['shipaddr'];
        } else {
            $addrShip = $this->cusrow['addr1'].', '.$this->cusrow['dist1'].', '.$this->cusrow['pin1'].' Phone:'.$this->cusrow['phone1'];
        }

        $this->SetX(105);
        $this->Cell(25, 5, 'Address', 0, 0, 'L');
        $this->MultiCell(70, 5, ': '.$addrShip, 0, 'L');

        $this->SetX(105);
        $this->Cell(25, 5, 'State', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->cusrow['state1'], 0, 1, 'L');

        $this->SetX(105);
        $this->Cell(25, 5, 'GSTIN', 0, 0, 'L');
        $this->Cell(70, 5, ': '.$this->cusrow['gst'], 0, 1, 'L');

        $this->SetX(105);
        $this->Cell(25, 5, 'PAN', 0, 0, 'L');
        $refNoteStr = '';
        if (strlen($this->row['ref']) > 0) {
            $ref_note = substr($this->row['ref'], 0, strpos($this->row['ref'], '|'));
            $refNoteStr = "   Reference : ".$ref_note;
        }
        $this->Cell(70, 5, ': '.$this->cusrow['cst'].$refNoteStr, 0, 1, 'L');

        $hRight = $this->GetY() - $y1;

        $h = max($hLeft, $hRight);

        // Draw borders around both halves
        $this->Rect(10, $y1, 95, $h);
        $this->Rect(105, $y1, 95, $h);

        $this->SetY($y1 + $h + 2);
    }

    function ItemsHeader()
    {
        $this->SetFont('Arial','B',7);

        // width approx: total ~190
        if ($this->isIntrastate) {
            if ($this->valvolineflg == 0) {
                $this->Cell(8, 6, 'SlNo', 1, 0, 'C');
                $this->Cell(24, 6, 'Part No(HSN Code)', 1, 0, 'C');
                $this->Cell(40, 6, 'Part Name', 1, 0, 'C');
                $this->Cell(10, 6, 'UoM', 1, 0, 'C');
                $this->Cell(16, 6, 'MRP/Unit', 1, 0, 'C');
                $this->Cell(10, 6, 'Qty', 1, 0, 'C');
                $this->Cell(16, 6, 'Price', 1, 0, 'C');
                $this->Cell(10, 6, 'Disc%', 1, 0, 'C');
                $this->Cell(14, 6, 'Disc Amt', 1, 0, 'C');
                $this->Cell(14, 6, 'Cash Disc', 1, 0, 'C');
                $this->Cell(16, 6, 'Sale Rate', 1, 0, 'C');
                $this->Cell(16, 6, 'Total', 1, 1, 'C');
            } else {
                // valvoline: UoM colspan=2 in HTML; here we just use same width
                $this->Cell(8, 6, 'SlNo', 1, 0, 'C');
                $this->Cell(24, 6, 'Part No(HSN Code)', 1, 0, 'C');
                $this->Cell(40, 6, 'Part Name', 1, 0, 'C');
                $this->Cell(20, 6, 'UoM', 1, 0, 'C');
                $this->Cell(10, 6, 'Qty', 1, 0, 'C');
                $this->Cell(16, 6, 'Price', 1, 0, 'C');
                $this->Cell(10, 6, 'Disc%', 1, 0, 'C');
                $this->Cell(14, 6, 'Disc Amt', 1, 0, 'C');
                $this->Cell(14, 6, 'Cash Disc', 1, 0, 'C');
                $this->Cell(16, 6, 'Sale Rate', 1, 0, 'C');
                $this->Cell(16, 6, 'Total', 1, 1, 'C');
            }
        } else { // INTERSTATE
            if ($this->valvolineflg == 0) {
                $this->Cell(8, 6, 'SlNo', 1, 0, 'C');
                $this->Cell(24, 6, 'Part No(HSN Code)', 1, 0, 'C');
                $this->Cell(40, 6, 'Part Name', 1, 0, 'C');
                $this->Cell(10, 6, 'UoM', 1, 0, 'C');
                $this->Cell(16, 6, 'MRP/Unit', 1, 0, 'C');
                $this->Cell(10, 6, 'Qty', 1, 0, 'C');
                $this->Cell(16, 6, 'Price', 1, 0, 'C');
                $this->Cell(10, 6, 'Disc%', 1, 0, 'C');
                $this->Cell(14, 6, 'Disc Amt', 1, 0, 'C');
                $this->Cell(14, 6, 'Cash Disc', 1, 0, 'C');
                $this->Cell(16, 6, 'Sale Rate', 1, 0, 'C');
                $this->Cell(16, 6, 'Total', 1, 1, 'C');
            } else {
                $this->Cell(8, 6, 'SlNo', 1, 0, 'C');
                $this->Cell(24, 6, 'Part No(HSN Code)', 1, 0, 'C');
                $this->Cell(40, 6, 'Part Name', 1, 0, 'C');
                $this->Cell(20, 6, 'UoM', 1, 0, 'C');
                $this->Cell(10, 6, 'Qty', 1, 0, 'C');
                $this->Cell(16, 6, 'Price', 1, 0, 'C');
                $this->Cell(10, 6, 'Disc%', 1, 0, 'C');
                $this->Cell(14, 6, 'Disc Amt', 1, 0, 'C');
                $this->Cell(14, 6, 'Cash Disc', 1, 0, 'C');
                $this->Cell(16, 6, 'Sale Rate', 1, 0, 'C');
                $this->Cell(16, 6, 'Total', 1, 1, 'C');
            }
        }
    }

    function CheckItemPageBreak()
    {
        // If close to bottom, new page + header + (if first page not done, no receiver block again)
        if ($this->GetY() > 250) {
            $this->AddPage();
            $this->ItemsHeader();
        }
    }

    function DrawItemRow($item)
    {
        $this->SetFont('Arial','',7);

        $sl = $item['slno'];
        $code = $item['code'];
        $hsn = $item['hsn'];
        $name = $item['name'];
        $qty = $item['qty'];
        $rate = $item['rate'];
        $discper = $item['discper'];
        $cshdisc = $item['cshdisc'];
        $mrp = $item['cessamt'];

        // recompute disc amounts / sale rate / total
        $qtyAmt = $qty * $rate;
        $discAmt = $qtyAmt * $discper / 100;
        $afterDisc = $qtyAmt - $discAmt;
        $cashDiscAmt = $afterDisc * $cshdisc / 100;
        $totalRate = round($afterDisc - $cashDiscAmt, 2);
        $saleRate = ($qty > 0) ? round($totalRate / $qty, 2) : 0;

        if ($mrp <= 0) {
            // fetch mrp from spareprmast if needed
            // not strictly required, but matching old logic
        }

        $muom = 'NOS'; // old code default when mrp<=0; we keep simple

        $hsnShow = ($hsn != '' && $hsn != '0') ? '(' . $hsn . ')' : '';

        $this->CheckItemPageBreak();

        if ($this->isIntrastate) {
            if ($this->valvolineflg == 0) {
                $this->Cell(8, 5, $sl, 1, 0, 'C');
                $this->Cell(24, 5, $code, 1, 0, 'L');
                $this->Cell(40, 5, $hsnShow, 1, 0, 'L');
                $this->Cell(10, 5, $name, 1, 0, 'L'); // NOTE: compressed due to width
                $this->Cell(16, 5, putcoma_pdf($mrp), 1, 0, 'R');
                $this->Cell(10, 5, $qty, 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($rate), 1, 0, 'R');
                $this->Cell(10, 5, $discper, 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($discAmt), 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($cashDiscAmt), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($saleRate), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($totalRate), 1, 1, 'R');
            } else {
                $this->Cell(8, 5, $sl, 1, 0, 'C');
                $this->Cell(24, 5, $code, 1, 0, 'L');
                $this->Cell(40, 5, $hsnShow, 1, 0, 'L');
                $this->Cell(20, 5, $name, 1, 0, 'L');
                $this->Cell(10, 5, $qty, 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($rate), 1, 0, 'R');
                $this->Cell(10, 5, $discper, 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($discAmt), 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($cashDiscAmt), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($saleRate), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($totalRate), 1, 1, 'R');
            }
        } else { // INTERSTATE
            if ($this->valvolineflg == 0) {
                $this->Cell(8, 5, $sl, 1, 0, 'C');
                $this->Cell(24, 5, $code, 1, 0, 'L');
                $this->Cell(40, 5, $hsnShow, 1, 0, 'L');
                $this->Cell(10, 5, $name, 1, 0, 'L');
                $this->Cell(16, 5, putcoma_pdf($mrp), 1, 0, 'R');
                $this->Cell(10, 5, $qty, 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($rate), 1, 0, 'R');
                $this->Cell(10, 5, $discper, 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($discAmt), 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($cashDiscAmt), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($saleRate), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($totalRate), 1, 1, 'R');
            } else {
                $this->Cell(8, 5, $sl, 1, 0, 'C');
                $this->Cell(24, 5, $code, 1, 0, 'L');
                $this->Cell(40, 5, $hsnShow, 1, 0, 'L');
                $this->Cell(20, 5, $name, 1, 0, 'L');
                $this->Cell(10, 5, $qty, 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($rate), 1, 0, 'R');
                $this->Cell(10, 5, $discper, 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($discAmt), 1, 0, 'R');
                $this->Cell(14, 5, putcoma_pdf($cashDiscAmt), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($saleRate), 1, 0, 'R');
                $this->Cell(16, 5, putcoma_pdf($totalRate), 1, 1, 'R');
            }
        }
    }
}

// ---------- Create PDF ----------
$pdf = new SpareInvoicePDF('P','mm','A4');
$pdf->AliasNbPages();

$pdf->invTitleNo     = $invTitleNo;
$pdf->invDate        = $fromdt1;
$pdf->row            = $row;
$pdf->brrow          = $brrow;
$pdf->cusrow         = $cusrow;
$pdf->brcode         = $brcode;
$pdf->signedqr       = $signedqr;
$pdf->irnno          = $qrrow['irnno'] ?? '';
$pdf->qrImagePath    = $qrImagePath;
$pdf->isIntrastate   = $isIntrastate;
$pdf->isInterstate   = $isInterstate;
$pdf->valvolineflg   = $valvolineflg;

$pdf->SetMargins(10, 10, 10);
$pdf->AddPage();

// Receiver / Consignee (first page only)
$pdf->ReceiverConsigneeBlock();

// Items header
$pdf->ItemsHeader();

// Items rows
foreach ($items as $it) {
    $pdf->DrawItemRow($it);
}

// After items: totals block (Accounts) and signatures, HSN summary
$pdf->Ln(3);

// DSR / Prepared / Verified + Accounts table
$pdf->SetFont('Arial','',8);
$pdf->Cell(65, 6, 'DSR: '.$eng, 1, 0, 'L');
$pdf->Cell(65, 6, 'Prepared by: '.$ref_user, 1, 0, 'L');
$pdf->Cell(60, 6, 'Verified by: --', 1, 1, 'L');

// Accounts table on right
$pdf->Ln(2);
$startY = $pdf->GetY();
$pdf->SetFont('Arial','',8);
$pdf->MultiCell(90, 4, '', 0, 'L'); // left blank area for signatures etc.

$pdf->SetXY(100, $startY);
$pdf->SetFont('Arial','B',8);
$pdf->Cell(60, 5, 'Accounts', 1, 1, 'C');

$pdf->SetFont('Arial','',8);
$pdf->SetX(100);
$pdf->Cell(30, 5, 'Parts Total', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($partstotal), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'DISCOUNT', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf(round($total_disc,2)), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'CASH DISCOUNT', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf(round($totcshdis,2)), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'CGST Total', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($cgst_tot), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'SGST Total', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($sgst_tot), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'IGST Total', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($igst_tot), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'TCS Total', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($tcs_tot), 1, 1, 'R');

$pdf->SetX(100);
$pdf->Cell(30, 5, 'Handling Charge', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($hand_tot), 1, 1, 'R');

// Round off
$dif1 = round($jtot);
$dif  = round(($dif1 - $jtot), 2);

$pdf->SetX(100);
$pdf->Cell(30, 5, 'Round Off', 1, 0, 'R');
$pdf->Cell(30, 5, putcoma_pdf($dif), 1, 1, 'R');

$pdf->SetX(100);
$pdf->SetFont('Arial','B',9);
$pdf->Cell(30, 6, 'Net Amount', 1, 0, 'R');
$pdf->Cell(30, 6, putcoma_pdf(round($jtot)), 1, 1, 'R');

$pdf->Ln(10);

// Customer signature
$pdf->SetFont('Arial','',8);
$pdf->Cell(0, 5, 'SIGNATURE OF CUSTOMER.', 0, 1, 'L');

$pdf->Ln(5);

// HSN summary table
$pdf->SetFont('Arial','B',8);
$pdf->Cell(0, 6, 'HSN SUMMARY', 1, 1, 'C');

$pdf->SetFont('Arial','B',7);
$pdf->Cell(20, 5, 'HSN', 1, 0, 'C');
$pdf->Cell(25, 5, 'Taxable Amt', 1, 0, 'C');
$pdf->Cell(15, 5, 'IGST Rate', 1, 0, 'C');
$pdf->Cell(25, 5, 'IGST Value', 1, 0, 'C');
$pdf->Cell(15, 5, 'CGST Rate', 1, 0, 'C');
$pdf->Cell(25, 5, 'CGST Value', 1, 0, 'C');
$pdf->Cell(15, 5, 'SGST Rate', 1, 0, 'C');
$pdf->Cell(25, 5, 'SGST Value', 1, 0, 'C');
$pdf->Cell(25, 5, 'Total With Tax', 1, 1, 'C');

$pdf->SetFont('Arial','',7);

// HSN aggregation query - same idea as in HTML
$re11 = mysqli_query(
    $db,
    "SELECT SUM(aprice) as taxable,
            cgstp, sgstp, igstp,
            SUM(cgstamt) as scgst,
            SUM(sgstamt) as ssgst,
            SUM(igstamt) as sigst,
            location
     FROM spareinvoice, partmaster
     WHERE invno='$invno'
       AND spareinvoice.brcode = '$brcode'
       AND partmaster.partcode = spareinvoice.partcode
     GROUP BY location"
);

$mprv_hsncode = 'NEW';
$mbef_tax = 0;
$mcgstamt = 0;
$msgstamt = 0;
$migstamt = 0;
$mprev_cgstp = 0;
$mprev_sgstp = 0;
$mprev_igstp = 0;

while ($res11 = mysqli_fetch_array($re11)) {
    if ($mprv_hsncode != 'NEW' && $mprv_hsncode != $res11['location']) {
        $ptot1 = $mbef_tax + $mcgstamt + $msgstamt + $migstamt;
        $pdf->Cell(20, 5, $mprv_hsncode, 1, 0, 'L');
        $pdf->Cell(25, 5, putcoma_pdf($mbef_tax), 1, 0, 'R');
        $pdf->Cell(15, 5, $mprev_igstp, 1, 0, 'R');
        $pdf->Cell(25, 5, putcoma_pdf($migstamt), 1, 0, 'R');
        $pdf->Cell(15, 5, $mprev_cgstp, 1, 0, 'R');
        $pdf->Cell(25, 5, putcoma_pdf($mcgstamt), 1, 0, 'R');
        $pdf->Cell(15, 5, $mprev_sgstp, 1, 0, 'R');
        $pdf->Cell(25, 5, putcoma_pdf($msgstamt), 1, 0, 'R');
        $pdf->Cell(25, 5, putcoma_pdf($ptot1), 1, 1, 'R');

        $mbef_tax = 0;
        $mcgstamt = 0;
        $msgstamt = 0;
        $migstamt = 0;
    }

    $mprev_cgstp = $res11['cgstp'];
    $mprev_sgstp = $res11['sgstp'];
    $mprev_igstp = $res11['igstp'];

    $mbef_tax += $res11['taxable'];
    $mcgstamt += $res11['scgst'];
    $msgstamt += $res11['ssgst'];
    $migstamt += $res11['sigst'];
    $mprv_hsncode = $res11['location'];
}

// print last group
$ptot1 = $mbef_tax + $mcgstamt + $msgstamt + $migstamt;
$pdf->Cell(20, 5, $mprv_hsncode, 1, 0, 'L');
$pdf->Cell(25, 5, putcoma_pdf($mbef_tax), 1, 0, 'R');
$pdf->Cell(15, 5, $mprev_igstp, 1, 0, 'R');
$pdf->Cell(25, 5, putcoma_pdf($migstamt), 1, 0, 'R');
$pdf->Cell(15, 5, $mprev_cgstp, 1, 0, 'R');
$pdf->Cell(25, 5, putcoma_pdf($mcgstamt), 1, 0, 'R');
$pdf->Cell(15, 5, $mprev_sgstp, 1, 0, 'R');
$pdf->Cell(25, 5, putcoma_pdf($msgstamt), 1, 0, 'R');
$pdf->Cell(25, 5, putcoma_pdf($ptot1), 1, 1, 'R');

$pdf->Output('I', 'SpareInvoice_'.$invno.'.pdf');

// Clean up QR temp image if exists
if ($qrImagePath && file_exists($qrImagePath)) {
    @unlink($qrImagePath);
}
?>
